using System;
using System.Collections.Generic;
using System.Text;

namespace EventSample
{
   class Program
   {
      static void Main(string[] args)
      {
         LongTask lt = new LongTask();
         lt.OnNotifyProgress += new LongTask.NotifyProgressDelegate(lt_OnNotifyProgress);

         lt.PerformTask();

         Console.ReadLine();
      }

      static void lt_OnNotifyProgress(ProgressArgs pa)
      {
         Console.WriteLine("Postp w wykonywaniu dugotrwaego zadania: {0}%",
            pa.PercentComplete);
      }
   }
   class LongTask
   {
      public delegate void NotifyProgressDelegate(ProgressArgs pa);

      public event NotifyProgressDelegate OnNotifyProgress;

      public void PerformTask()
      {
         for (int i = 0; i < 10000; i++)
         {
            // wykonaj jakie obliczenia
            // ...

            // powiadom subskrybentw o postpie w wykonaniu
            if (i % 100 == 0)
            {
               OnNotifyProgress(new ProgressArgs((int)i / 100));
            }
         }
      }
   }

   class ProgressArgs
   {
      public ProgressArgs(int pctComplete)
      {
         PercentComplete = pctComplete;
      }
      public int PercentComplete;
   }
}
